/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.blocks.statues;

import com.mojang.authlib.GameProfile;
import com.shynieke.statues.blockentities.PlayerBlockEntity;
import com.shynieke.statues.blocks.AbstractBaseBlock;
import com.shynieke.statues.config.StatuesConfig;
import com.shynieke.statues.entity.PlayerStatue;
import com.shynieke.statues.init.StatueBlockEntities;
import com.shynieke.statues.init.StatueRegistry;
import com.shynieke.statues.init.StatueTags;
import com.shynieke.statues.items.PlayerStatueSpawnItem;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.StringUtil;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PlayerStatueBlock
extends AbstractBaseBlock {
    private static final VoxelShape SHAPE = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    public static final BooleanProperty ONLINE = BooleanProperty.m_61465_((String)"online");

    public PlayerStatueBlock(BlockBehaviour.Properties builder) {
        super(builder.m_60918_(SoundType.f_56742_));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE)).m_61124_((Property)ONLINE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new PlayerBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return PlayerStatueBlock.createStatueTicker(level, blockEntityType, (BlockEntityType<? extends PlayerBlockEntity>)((BlockEntityType)StatueBlockEntities.PLAYER.get()));
    }

    @Nullable
    protected static <T extends BlockEntity> BlockEntityTicker<T> createStatueTicker(Level level, BlockEntityType<T> blockEntityType, BlockEntityType<? extends PlayerBlockEntity> blockEntityType1) {
        return level.f_46443_ ? null : PlayerStatueBlock.m_152132_(blockEntityType, blockEntityType1, PlayerBlockEntity::serverTick);
    }

    private PlayerBlockEntity getBE(Level world, BlockPos pos) {
        return (PlayerBlockEntity)world.m_7702_(pos);
    }

    @Override
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void m_6240_(Level worldIn, Player player, BlockPos pos, BlockState state, BlockEntity be, ItemStack stack) {
        if (be instanceof PlayerBlockEntity) {
            PlayerBlockEntity blockEntity = (PlayerBlockEntity)be;
            if (((Nameable)be).m_8077_()) {
                player.m_36399_(0.005f);
                if (worldIn.f_46443_) {
                    return;
                }
                if (this == Blocks.f_50016_) {
                    return;
                }
                ItemStack itemstack = new ItemStack((ItemLike)this);
                itemstack.m_41714_(blockEntity.m_7755_());
                if (blockEntity.getPlayerProfile() != null) {
                    CompoundTag stackTag = itemstack.m_41783_() != null ? itemstack.m_41783_() : new CompoundTag();
                    CompoundTag tag = new CompoundTag();
                    NbtUtils.m_129230_((CompoundTag)tag, (GameProfile)blockEntity.getPlayerProfile());
                    stackTag.m_128365_("PlayerProfile", (Tag)tag);
                    itemstack.m_41751_(stackTag);
                    itemstack.m_41714_(blockEntity.m_7755_());
                }
                PlayerStatueBlock.m_49840_((Level)worldIn, (BlockPos)pos, (ItemStack)itemstack);
                if (!blockEntity.getComparatorApplied()) return;
                PlayerStatueBlock.m_49840_((Level)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)Blocks.f_50328_.m_5456_()));
                return;
            }
        }
        super.m_6240_(worldIn, player, pos, state, null, stack);
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean p_196243_5_) {
        if (state.m_155947_() && newState.m_60734_() != StatueRegistry.PLAYER_STATUE.get()) {
            worldIn.m_46747_(pos);
        }
    }

    public ItemStack m_142598_(LevelAccessor level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof PlayerBlockEntity) {
            return this.getStatueWithName((BlockGetter)level, pos, state);
        }
        return new ItemStack((ItemLike)state.m_60734_());
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof PlayerBlockEntity) {
            return this.getStatueWithName(level, pos, state);
        }
        return super.getCloneItemStack(state, target, level, pos, player);
    }

    private ItemStack getStatueWithName(BlockGetter level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof PlayerBlockEntity) {
            PlayerBlockEntity playerBlockEntity = (PlayerBlockEntity)blockEntity;
            ItemStack stack = new ItemStack((ItemLike)state.m_60734_());
            GameProfile profile = playerBlockEntity.getPlayerProfile();
            if (profile != null) {
                CompoundTag tag = new CompoundTag();
                if (!StringUtil.m_14408_((String)profile.getName())) {
                    GameProfile gameprofile = new GameProfile((UUID)null, profile.getName());
                    PlayerBlockEntity.updateGameprofile(gameprofile, newProfile -> tag.m_128365_("PlayerProfile", (Tag)NbtUtils.m_129230_((CompoundTag)new CompoundTag(), (GameProfile)newProfile)));
                }
                stack.m_41751_(tag);
            }
            return stack.m_41714_(playerBlockEntity.m_7755_());
        }
        return new ItemStack((ItemLike)state.m_60734_());
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(worldIn, pos, (BlockState)state.m_61124_((Property)ONLINE, (Comparable)Boolean.valueOf(false)), placer, stack);
        if (!worldIn.f_46443_ && this.getBE(worldIn, pos) != null) {
            PlayerBlockEntity playerBlockEntity = this.getBE(worldIn, pos);
            if (stack.m_41788_()) {
                String stackName = stack.m_41786_().m_6111_();
                boolean spaceFlag = stackName.contains(" ");
                boolean emptyFlag = stackName.isEmpty();
                if (!spaceFlag && !emptyFlag) {
                    GameProfile foundProfile;
                    CompoundTag tag;
                    GameProfile newProfile = new GameProfile((UUID)null, stackName);
                    if (stack.m_41782_() && stack.m_41783_() != null && (tag = stack.m_41783_()).m_128441_("PlayerProfile") && (foundProfile = NbtUtils.m_129228_((CompoundTag)tag.m_128469_("PlayerProfile"))) != null && foundProfile.getName().equalsIgnoreCase(stackName)) {
                        newProfile = foundProfile;
                    }
                    playerBlockEntity.setPlayerProfile(newProfile);
                }
            } else if (placer instanceof Player) {
                Player player = (Player)placer;
                playerBlockEntity.setPlayerProfile(player.m_36316_());
            } else {
                playerBlockEntity.setPlayerProfile(new GameProfile((UUID)null, "steve"));
            }
        }
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (Screen.m_96638_() && stack.m_41782_()) {
            GameProfile gameprofile;
            CompoundTag profileTag;
            CompoundTag tag = stack.m_41783_();
            MutableComponent userComponent = new TextComponent("Username: ").m_130940_(ChatFormatting.GOLD);
            userComponent.m_7220_((Component)stack.m_41786_().m_6879_().m_130940_(ChatFormatting.WHITE));
            tooltip.add((Component)userComponent);
            if (tag != null && tag.m_128441_("PlayerProfile") && (profileTag = (CompoundTag)tag.m_128423_("PlayerProfile")) != null && (gameprofile = NbtUtils.m_129228_((CompoundTag)profileTag)) != null && gameprofile.isComplete()) {
                MutableComponent UUIDComponent = new TextComponent("UUID: ").m_130940_(ChatFormatting.GOLD);
                UUIDComponent.m_7220_((Component)new TextComponent(gameprofile.getId().toString()).m_130940_(ChatFormatting.WHITE));
                tooltip.add((Component)UUIDComponent);
            }
        }
        super.m_5871_(stack, worldIn, tooltip, flagIn);
    }

    public int m_6378_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        if (((Boolean)blockState.m_61143_((Property)ONLINE)).booleanValue()) {
            return 15;
        }
        return 0;
    }

    public boolean m_7899_(BlockState state) {
        return (Boolean)state.m_61143_((Property)ONLINE);
    }

    public boolean shouldCheckWeakPower(BlockState state, LevelReader world, BlockPos pos, Direction side) {
        return false;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> blockStateBuilder) {
        blockStateBuilder.m_61104_(new Property[]{FACING, WATERLOGGED, ONLINE});
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player playerIn, InteractionHand hand, BlockHitResult result) {
        ItemStack stack = playerIn.m_21120_(hand);
        GameProfile tileProfile = this.getBE(level, pos).getPlayerProfile();
        PlayerBlockEntity playerBlockEntity = this.getBE(level, pos);
        if (!level.f_46443_ && playerBlockEntity != null && tileProfile != null) {
            boolean onlineFlag;
            String playerName = tileProfile.getName();
            boolean bl = onlineFlag = level.m_46003_(tileProfile.getId()) != null;
            if (playerIn.m_6144_()) {
                if (playerBlockEntity.getComparatorApplied()) {
                    playerBlockEntity.setComparatorApplied(false);
                    ItemStack comparatorStack = new ItemStack((ItemLike)Items.f_42351_);
                    if (!playerIn.m_36356_(comparatorStack)) {
                        level.m_7967_((Entity)new ItemEntity(level, (double)pos.m_123341_(), (double)pos.m_123342_() + 0.5, (double)pos.m_123343_(), comparatorStack));
                    }
                }
                return InteractionResult.SUCCESS;
            }
            if (((Boolean)StatuesConfig.COMMON.playerCompass.get()).booleanValue()) {
                if (stack.m_41720_() == Items.f_42522_ || stack.m_41720_() == StatueRegistry.PLAYER_COMPASS.get()) {
                    boolean isPlayerCompass;
                    boolean bl2 = isPlayerCompass = stack.m_41720_() == StatueRegistry.PLAYER_COMPASS.get();
                    if (onlineFlag) {
                        ItemStack playerCompass = isPlayerCompass ? stack : new ItemStack((ItemLike)StatueRegistry.PLAYER_COMPASS.get());
                        CompoundTag locationTag = new CompoundTag();
                        Player player = level.m_46003_(tileProfile.getId());
                        if (player != null && player.f_19853_.m_46472_().m_135782_().equals((Object)playerIn.f_19853_.m_46472_().m_135782_())) {
                            BlockPos playerPos = player.m_142538_();
                            locationTag.m_128356_("lastPlayerLocation", playerPos.m_121878_());
                            locationTag.m_128359_("playerTracking", tileProfile.getName());
                            playerCompass.m_41751_(locationTag);
                            if (!isPlayerCompass) {
                                if (!playerIn.m_150110_().f_35937_) {
                                    stack.m_41774_(1);
                                }
                                if (stack.m_41619_()) {
                                    playerIn.m_21008_(hand, playerCompass);
                                } else if (!playerIn.m_150109_().m_36054_(playerCompass)) {
                                    playerIn.m_36176_(playerCompass, false);
                                }
                            }
                        } else {
                            playerIn.m_6352_((Component)new TranslatableComponent("statues:player.compass.dimension.failure", new Object[]{ChatFormatting.GOLD + playerName}), Util.f_137441_);
                        }
                    } else {
                        playerIn.m_6352_((Component)new TranslatableComponent("statues:player.compass.offline", new Object[]{ChatFormatting.GOLD + playerName}), Util.f_137441_);
                    }
                    return InteractionResult.SUCCESS;
                }
                if (stack.m_41720_() == Items.f_42351_ && !playerBlockEntity.getComparatorApplied()) {
                    if (!playerIn.m_150110_().f_35937_) {
                        stack.m_41774_(1);
                    }
                    playerBlockEntity.setComparatorApplied(true);
                    playerBlockEntity.updateOnline();
                    return InteractionResult.SUCCESS;
                }
                if (stack.m_204117_(StatueTags.PLAYER_UPGRADE_ITEM) && level instanceof ServerLevel) {
                    ServerLevel serverworld = (ServerLevel)level;
                    PlayerStatue playerStatueEntity = (PlayerStatue)((EntityType)StatueRegistry.PLAYER_STATUE_ENTITY.get()).m_20655_(serverworld, stack.m_41783_(), playerBlockEntity.m_7755_(), playerIn, pos, MobSpawnType.SPAWN_EGG, true, true);
                    if (playerStatueEntity == null) {
                        return InteractionResult.FAIL;
                    }
                    serverworld.m_47205_((Entity)playerStatueEntity);
                    float f = (float)Mth.m_14143_((float)((Mth.m_14177_((float)(playerIn.m_146908_() - 180.0f)) + 22.5f) / 45.0f)) * 45.0f;
                    playerStatueEntity.setGameProfile(playerBlockEntity.getPlayerProfile());
                    playerStatueEntity.m_7678_(playerStatueEntity.m_20185_(), playerStatueEntity.m_20186_(), playerStatueEntity.m_20189_(), f, 0.0f);
                    PlayerStatueSpawnItem.applyRandomRotations(playerStatueEntity, level.f_46441_);
                    level.m_46597_(pos, Blocks.f_50016_.m_49966_());
                    level.m_7967_((Entity)playerStatueEntity);
                    level.m_6263_((Player)null, playerStatueEntity.m_20185_(), playerStatueEntity.m_20186_(), playerStatueEntity.m_20189_(), SoundEvents.f_11684_, SoundSource.BLOCKS, 0.75f, 0.8f);
                    if (!playerIn.m_150110_().f_35937_) {
                        stack.m_41774_(1);
                    }
                }
            }
        }
        return InteractionResult.PASS;
    }

    @Override
    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)((BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)))).m_61124_((Property)ONLINE, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return (BlockState)state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING))).m_61124_((Property)ONLINE, (Comparable)Boolean.valueOf(false));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }
}

